function D = get_gradient_gmm_sup_dem(param, N_variables, N_ll)
% This function numerically computes the gradient of model moments for
% theta, the estimated parameters. 
% Relative to get_gradient_gmm, this function varies the variance of both
% shocks and the importance of productivity shocks (as appears in Table 7).

M = (N_variables+1)*N_variables/2 + N_variables * N_ll ; % Number of moments
T = 17; % Total parameters
N = 5; % Estimated parameters

D = nan(M, N);
I = eye(T);

estimated = [13:17];

h = min(abs(param/1.2), 0.2*10^(-5));


for j = estimated
    
    if j<16
        moments_u = Model_Moments(param + I(j, :) * h(j), N_variables, N_ll);
        moments_d = Model_Moments(param - I(j, :) * h(j), N_variables, N_ll);
        ind = j==estimated;
        D(:, ind) = (moments_u - moments_d)/(2*h(j));
    elseif j==16
        moments_u = Model_Moments([param(1:15), param(16) * (1+ h(j)),  (param(17) * (1+ h(j)))], N_variables, N_ll);
        moments_d = Model_Moments([param(1:15), param(16) * (1 - h(j)), (param(17) * (1 - h(j)))], N_variables, N_ll);
        ind = j==estimated;
        D(:, ind) = (moments_u - moments_d)/(2*h(j));
    else
        moments_u = Model_Moments([param(1:15), param(16) / (1 + h(j)),  (param(17)  * (1 + h(j)))], N_variables, N_ll);
        moments_d = Model_Moments([param(1:15), param(16) / (1 - h(j)),  (param(17)  * (1 - h(j)))], N_variables, N_ll);
        ind = j==estimated;
        D(:, ind) = (moments_u - moments_d)/(2*h(j));
    end
    
    
end

D = D';

